<?php
ob_start();
session_start();





/*
 * required files
 */
require_once ('./models/PHP-MySQLi-Database-Class/MysqliDb.php');
require_once("./models/config.php"); // connect with db and load site info
require_once("./models/functions.php"); // site functions





/*
 * page variables
 */
$page_name = 'Software Settings';
$page_name_single = '';






/*
 * if user is not logged in redirect to login
 */
if ((!isset($_SESSION['sess_user_id']) || (trim(isset($_SESSION['sess_user_id'])) == ''))) {
  header("location: index.php");
  exit();
} else {

  if (($_SESSION['sess_user_id']) != 1) {
    header("location: dashboard.php");  // is logged in
    exit();
  }
  /*
   * set session variables
   */
  $user_id = $_SESSION['sess_user_id'];
  $username = $_SESSION['sess_username'];
  $user_email = $_SESSION['sess_user_email'];
}






/*
 * active menu links
 */
$menu_active = 'site_info';
$menu_sub_active = 'site_info';



/*
 * process form
 */

if (isset($_POST['edit_submit'])) {


//  print_r($_POST);
//  die();

  if ($errors == '') {



    $site_favicon_post = $_FILES['site_favicon']['name'];
    $site_favicon_temp = $_FILES['site_favicon']['tmp_name'];

    if ($site_favicon_post == '') {
      $site_favicon_post = $site_favicon;
    } else {
      $upload_path = $upload_path . "site_info/";
      $site_favicon_post = $anyNum . "_" . $site_favicon_post;
      copy($site_favicon_temp, $upload_path . $site_favicon_post);
    }

    $site_logo_post = $_FILES['site_logo']['name'];
    $site_logo_temp = $_FILES['site_logo']['tmp_name'];

    if ($site_logo_post == '') {
      $site_logo_post = $site_logo;
    } else {
      $upload_path = $upload_path . "site_info/";
      $site_logo_post = $anyNum . "_" . $site_logo_post;
      copy($site_logo_temp, $upload_path . $site_logo_post);
    }

    $site_cover_picture_post = $_FILES['site_cover_picture']['name'];
    $site_cover_picture_temp = $_FILES['site_cover_picture']['tmp_name'];

    if ($site_cover_picture_post == '') {
      $site_cover_picture_post = $site_cover_picture;
    } else {
      $upload_path = $upload_path . "site_info/";
      $site_cover_picture_post = $anyNum . "_" . $site_cover_picture_post;
      copy($site_cover_picture_temp, $upload_path . $site_cover_picture_post);
    }




    $data = Array(
        'name' => $_POST['site_name'],
        'slogan' => $_POST['site_slogan'],
        'about' => $_POST['site_about'],
        'favicon' => $site_favicon_post,
        'cover_picture' => $site_cover_picture_post,
        'logo' => $site_logo_post,
        'email' => $_POST['site_email'],
        'email2' => $_POST['site_email2'],
        'phone' => $_POST['site_phone'],
        'fax_no' => $_POST['site_fax_no'],
        'address' => $_POST['site_address'],
        'zip' => $_POST['site_zip'],
        'city' => $_POST['site_city'],
        'state' => $_POST['site_state'],
        'country' => $_POST['site_country'],
        'copyright' => $_POST['site_copyright'],
    );

//        print_r($data);

    $db->where('id', $site_id);
    $db->update('site_info', $data);



    header('Location: site_info.php?success=Settings has been updated');
    die();
  }
}
?>
<!DOCTYPE html>
<html>
  <head lang="en">

    <title><?= $page_name ?> | <?php echo $site_name; ?> - <?php echo $site_slogan; ?></title>
    <meta name="description" content="<?php echo $site_name . '.' . $site_slogan ?>">

    <?php require_once './includes/head.php'; ?>
    <link rel="stylesheet" href="css/lib/summernote/summernote.css"/>


  </head>
  <body class="with-side-menu theme-side-litmus-blue">

    <?php require_once './includes/header.php'; ?>

    <?php require_once './includes/side-menu.php'; ?>

    <div class="page-content">
      <div class="container-fluid">

        <header class="section-header">
          <div class="tbl">
            <div class="tbl-row">
              <div class="tbl-cell">
                <h3><?= $page_name ?></h3>
              </div>
            </div>
          </div>
        </header>

        <?
        if ($errors != '') {
          echo '<div class = "alert alert-block alert-danger fade in">';
          foreach ($errors as $error) {
            echo '<p>' . $error . '.</p>';
          }
          echo '</div>';
        }
        if ($success != '') {
          echo '<div class = "alert alert-block alert-success fade in">';
          //foreach ($successes as $success) {
          echo '<p>' . $success . '.</p>';
          //}
          echo '</div>';
        }
        ?>

        <form enctype="multipart/form-data" role="form" method="POST" action="<?= $_SERVER['PHP_SELF'] ?>">

          <div class="box-typical box-typical-padding">

            <h5 class="with-border">Basic Info</h5>

            <div class="row">

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_name">Name</label>
                  <div>
                    <input type="text" id="site_name" name="site_name" class="form-control validate[required,maxSize[255]]" value="<?= $site_name ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_slogan">Slogan</label>
                  <div>
                    <input type="text" id="site_slogan" name="site_slogan" class="form-control validate[required,maxSize[255]]" value="<?= $site_slogan ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>


              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_about">About</label>
                  <div>
                    <input type="text" id="site_about" name="site_about" class="form-control validate[required,maxSize[255]]" value="<?= $site_about ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>
              <div class="clearfix"></div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_favicon">Favicon</label>
                  <div>
                    <input type="file" id="site_favicon" name="site_favicon" data-plugin="dropify" data-default-file="<? if ($site_favicon != '') echo $upload_path . 'site_info/' . $site_favicon ?>" />
                    <span class="help-block small">Formats: jgp, jpeg, gif, png and ico.</span>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_logo">Logo</label>
                  <div>
                    <input type="file" id="site_logo" name="site_logo" data-plugin="dropify" data-default-file="<? if ($site_logo != '') echo $upload_path . 'site_info/' . $site_logo ?>" />
                    <span class="help-block small">Formats: jgp, jpeg, gif, png and ico.</span>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="site_cover_picture">Cover / Introductory Photo</label>
                  <div>
                    <input type="file" id="site_cover_picture" name="site_cover_picture" data-plugin="dropify" data-default-file="<? if ($site_cover_picture != '') echo $upload_path . 'site_info/' . $site_cover_picture ?>"
                           />
                    <span class="help-block small">Formats: jgp, jpeg, gif, png and ico.</span>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_email">Email</label>
                  <div>
                    <input type="email" id="site_email" name="site_email" class="form-control validate[required,maxSize[255],custom[email]]" value="<?= $site_email ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_email2">Alternative Email</label>
                  <div>
                    <input type="email" id="site_email2" name="site_email2" class="form-control validate[maxSize[255],custom[email]]" value="<?= $site_email2 ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_phone">Phone Number</label>
                  <div>
                    <input type="text" id="site_phone" name="site_phone" class="form-control validate[maxSize[255]]" value="<?= $site_phone ?>"/>
                    <span class="help-block small">No white spaces or dashes, Country code instead of 0. </span>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_fax_no">Mobile Number</label>
                  <div>
                    <input type="text" id="site_fax_no" name="site_fax_no" class="form-control validate[maxSize[255]]" value="<?= $site_fax_no ?>"/>
                    <span class="help-block small">No white spaces or dashes, Country code instead of 0. </span>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

            </div>



            <div class="row">

              <div class="col-sm-12">
                <h5 class="with-border">Address & Map</h5>
                <div class="form-group">
                  <label for="site_address">Address</label>
                  <div>
                    <input type="text" id="site_address" name="site_address" class="form-control validate[required,maxSize[255]]" value="<?= $site_address ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_zip">Zip Code</label>
                  <div>
                    <input type="text" id="site_zip" name="site_zip" class="form-control validate[maxSize[255]]" value="<?= $site_zip ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_city">City</label>
                  <div>
                    <input type="text" id="site_city" name="site_city" class="form-control validate[maxSize[255]]" value="<?= $site_city ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_state">State</label>
                  <div>
                    <input type="text" id="site_state" name="site_state" class="form-control validate[maxSize[255]]" value="<?= $site_state ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-6">
                <div class="form-group">
                  <label for="site_country">Country</label>
                  <div>
                    <input type="text" id="site_country" name="site_country" class="form-control validate[maxSize[255]]" value="<?= $site_country ?>"/>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="col-sm-12">
                <h5 class="with-border">Legal Info</h5>
                <div class="form-group">
                  <label for="site_copyright">Copyright Text</label>
                  <div>
                    <textarea rows="1" id="site_copyright" name="site_copyright" class="form-control validate[maxSize[255]]" placeholder="Copyright &copy; to display in footer..."><?= $site_copyright ?></textarea>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

            </div>



          </div><!--.tab-content-->

          <div class="form-group text-center" >

            <button type="submit" class="btn btn-success" name="edit_submit" id="edit_submit"><i class="fa fa-check"></i>
              Update
            </button>

            <a href="languages_strings.php" class="btn btn-default"><i class="fa fa-times"></i>
              Cancel
            </a>
          </div>

        </form>

      </div><!--.container-fluid-->
    </div><!--.page-content-->

    <?php require_once './includes/footer.php'; ?>


  </body>
</html>