<?php
ob_start();
session_start();





/*
 * required files
 */
require_once ('./models/PHP-MySQLi-Database-Class/MysqliDb.php');
require_once("./models/config.php"); // connect with db and load site info
require_once("./models/functions.php"); // site functions





/*
 * page variables
 */
$page_name = 'User Settings';
$page_name_single = '';






/*
 * if user is not logged in redirect to login
 */
if ((!isset($_SESSION['sess_user_id']) || (trim(isset($_SESSION['sess_user_id'])) == ''))) {
  header("location: index.php");
  exit();
} else {
  /*
   * set session variables
   */
  $user_id = $_SESSION['sess_user_id'];
  $username = $_SESSION['sess_username'];
  $user_email = $_SESSION['sess_user_email'];
}






/*
 * active menu links
 */
$menu_active = 'settings';
$menu_sub_active = '';





/*
 * load user info single
 */
$db->where('id', $user_id);
$user_info = $db->getOne('users');
$settings_username = $user_info['username'];
$settings_email = $user_info['email'];
$settings_phone = $user_info['phone'];
$settings_first_name = $user_info['first_name'];
$settings_last_name = $user_info['last_name'];
$settings_salt = $user_info['salt'];
$settings_password = $user_info['password'];


/*
 * process form
 */

if (isset($_POST['user_single_submit'])) {

  $settings_username = $_POST['settings_username'];
  $settings_email = $_POST['settings_email'];
  $settings_phone = $_POST['settings_phone'];
  $settings_first_name = $_POST['settings_first_name'];
  $settings_last_name = $_POST['settings_last_name'];
  $settings_oldpass = $_POST['settings_oldpass'];
  $settings_newpass = $_POST['settings_newpass'];
  $settings_confirmpass = $_POST['settings_confirmpass'];

  if ($settings_username == '') {
    $errors[] = 'Please enter the Username';
  }
  if ($settings_email == '') {
    $errors[] = 'Please enter the Email';
  }
  if ($settings_phone == '') {
    $errors[] = 'Please enter the Phone';
  }
  if ($settings_oldpass != '') {

    if ($settings_password != hash('sha256', $settings_salt . hash('sha256', $settings_oldpass))) {
      $errors[] = 'Old Password does not match';
    }
    if ($settings_newpass == '') {
      $errors[] = 'Please enter the New Password';
    }
    if ($settings_newpass != $settings_confirmpass) {
      $errors[] = 'New Password does not match';
    }
    if ($settings_newpass == $settings_oldpass) {
      $errors[] = 'You can\'t update with the same password';
    }
  }

  if ($errors == '') {


    // passwprd
    $salt = createSalt();
    $settings_newpass = hash('sha256', $salt . hash('sha256', $settings_newpass));

    $db->where('id', $user_id);
    if ($settings_oldpass != '') {
      $data = Array(
          'username' => $settings_username,
          'email' => $settings_email,
          'phone' => $settings_phone,
          'first_name' => $settings_first_name,
          'last_name' => $settings_last_name,
          'password' => $settings_newpass,
          'salt' => $salt,
          'password_updated' => $db->now(),
      );
    } else {
      $data = Array(
          'username' => $settings_username,
          'email' => $settings_email,
          'phone' => $settings_phone,
          'first_name' => $settings_first_name,
          'last_name' => $settings_last_name,
      );
    }

    if ($db->update('users', $data)) {
      $_SESSION['sess_username'] = $settings_username;
      $_SESSION['sess_user_email'] = $settings_email;

      $success = 'Updated';

      header('Location: settings.php?success=' . $success);
      die();
    } else {
      echo 'error';
      die();
    }
  }
}
?>
<!DOCTYPE html>
<html>
  <head lang="en">

    <title><?= $page_name ?> | <?php echo $site_name; ?> - <?php echo $site_slogan; ?></title>
    <meta name="description" content="<?php echo $site_name . '.' . $site_slogan ?>">
    <meta name="author" content="<?php echo $site_email ?>">

    <?php require_once './includes/head.php'; ?>


  </head>
  <body class="with-side-menu theme-side-litmus-blue">

    <?php require_once './includes/header.php'; ?>

    <?php require_once './includes/side-menu.php'; ?>

    <div class="page-content">
      <div class="container-fluid">

        <header class="section-header">
          <div class="tbl">
            <div class="tbl-row">
              <div class="tbl-cell">
                <h3><?= $page_name ?></h3>
              </div>
            </div>
          </div>
        </header>

        <?
        if ($errors != '') {
          echo '<div class = "alert alert-block alert-danger fade in">';
          foreach ($errors as $error) {
            echo '<p>' . $error . '.</p>';
          }
          echo '</div>';
        }
        if ($success != '') {
          echo '<div class = "alert alert-block alert-success fade in">';
          //foreach ($successes as $success) {
          echo '<p>User Settings ' . $success . '.</p>';
          //}
          echo '</div>';
        }
        ?>

        <form enctype="multipart/form-data" role="form" method="POST" action="<?= $_SERVER['PHP_SELF'] ?>">

          <div class="box-typical box-typical-padding">
            <h5 class="with-border">Basic Info</h5>

            <div class="row">

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_username">Username</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-user"></i></div>
                      <input type="text" id="settings_username" name="settings_username" class="form-control validate[required,maxSize[255]]" value="<?= $settings_username ?>" readonly=""/>
                    </div>

                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_email">Email</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                      <input type="email" id="settings_email" name="settings_email" class="form-control validate[required,maxSize[255],custom[email]]" value="<?= $settings_email ?>" readonly=""/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>
              <div class="clearfix"></div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_first_name">First Name</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-user"></i></div>
                      <input type="text" id="settings_first_name" name="settings_first_name" class="form-control validate[required,maxSize[255]]" value="<?= $settings_first_name ?>"/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_last_name">Last Name</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-user"></i></div>
                      <input type="text" id="settings_last_name" name="settings_last_name" class="form-control validate[required,maxSize[255]]" value="<?= $settings_last_name ?>"/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_phone">Mobile Number</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-mobile"></i></div>
                      <input type="text" id="settings_phone" name="settings_phone" class="form-control validate[required,maxSize[255]]" value="<?= $settings_phone ?>" <? if ($settings_phone != '') echo 'readonly'; ?>/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

            </div>

          </div>
          <div class="box-typical box-typical-padding">
            <h5 class="with-border">Change Password</h5>

            <div class="row">

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_oldpass">Current Password</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                      <input type="password" id="settings_oldpass" name="settings_oldpass" class="form-control validate[maxSize[255]]" />
                    </div>

                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_newpass">New Password</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                      <input type="password" id="settings_newpass" name="settings_newpass" class="form-control validate[maxSize[255]]"/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

              <div class="col-sm-4">
                <div class="form-group">
                  <label for="settings_confirmpass">Confirm New Password</label>
                  <div>
                    <div class="input-group">
                      <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                      <input type="password" id="settings_confirmpass" name="settings_confirmpass" class="form-control validate[maxSize[255]]"/>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>

            </div>

          </div>

          <div class="form-group text-center">
            <button type="submit" class="btn btn-success" name="user_single_submit" id="user_single_submit"><i class="fa fa-check"></i>
              Update
            </button>
            <a href="dashboard.php" class="btn btn-default"><i class="fa fa-times"></i>
              Cancel
            </a>
          </div>

        </form>

      </div><!--.container-fluid-->
    </div><!--.page-content-->

    <?php require_once './includes/footer.php'; ?>


  </body>
</html>