<?php
ob_start();
session_start();





/*
 * required files
 */
require_once ('./models/PHP-MySQLi-Database-Class/MysqliDb.php');
require_once("./models/config.php"); // connect with db and load site info
require_once("./models/functions.php"); // site functions





/*
 * page variables
 */
$page_name = 'Customers';
$page_name_single = 'Customer';






/*
 * if user is not logged in redirect to login
 */
if ((!isset($_SESSION['sess_user_id']) || (trim(isset($_SESSION['sess_user_id'])) == ''))) {
  header("location: index.php");
  exit();
} else {

  if (($_SESSION['sess_user_id']) != 1) {
    header("location: dashboard.php");  // is logged in
    exit();
  }
  /*
   * set session variables
   */
  $user_id = $_SESSION['sess_user_id'];
  $username = $_SESSION['sess_username'];
  $user_email = $_SESSION['sess_user_email'];
}






/*
 * active menu links
 */
$menu_active = 'customers';
if ($page == 'view') {
  $menu_sub_active = 'view';
}
if ($page == 'my') {
  $menu_sub_active = 'my';
}
if (($page == 'edit') || ( $page == 'add')) {
  $menu_sub_active = 'addnedit';
}





/*
 * get identity values
 */
$edit_name = '';
$edit_phone = '';
$edit_email = '';
$edit_is_active = 1;

if ($edit_id != '') {

  $db->where('id', $edit_id);
  $db->where('is_delete', 0);

  $edit_info = $db->getOne('customers');

  $edit_name = $edit_info['name'];
  $edit_phone = $edit_info['phone'];
  $edit_email = $edit_info['email'];
  $edit_is_active = $edit_info['is_active'];

  if ($db->count == 0) {
    header('Location: customers.php?page=view');
    die();
  }
}





/*
 * delete process
 */
if ($do_delete == '1') {

  $db->where('id', $edit_id);
  $data = Array(
      'is_delete' => 1,
  );
  if ($db->update('customers', $data)) {
    $success = 'Deleted';
    header('Location: customers.php?page=view&edit_id=' . $edit_id . '&success=' . $success);
    die();
  } else {
    echo 'error';
    die();
  }
}





/*
 * process form
 */

if (isset($_POST['edit_submit'])) {

  $edit_name = $_POST['edit_name'];
  $edit_is_active = $_POST['edit_is_active'];
  $edit_phone = $_POST['edit_phone'];
  $edit_email = $_POST['edit_email'];
  if ($edit_name == '') {
    $errors[] = 'Please enter the Name';
  }

  // duplicate
  $db->where('email', $edit_email);
  $db->where('is_delete', 0);
  if ($page == 'edit') {
    $db->where('id!=' . $edit_id);
  }
  $duplicate_info = $db->getOne('customers');
  if ($db->count > 0) {
    $errors[] = 'Another entry with this email already exists';
  }

  // duplicate
  $db->where('phone', $edit_phone);
  $db->where('is_delete', 0);
  if ($page == 'edit') {
    $db->where('id!=' . $edit_id);
  }
  $duplicate_info = $db->getOne('customers');
  if ($db->count > 0) {
    $errors[] = 'Another entry with this phone already exists';
  }


  if ($errors == '') {

//    echo $edit_end_date;
//    die();



    $data = Array(
        'name' => $edit_name,
        'phone' => $edit_phone,
        'is_active' => $edit_is_active,
        'email' => $edit_email,
        'timestamp' => $db->now()
    );


    if ($page == 'edit') {


      $db->where('id', $edit_id);
      $db->update('customers', $data);

      $success = 'Updated';
    } else if ($page == 'add') {

      $edit_id = $db->insert('customers', $data);

      //   $edit_id = mysqli_insert_id($con);
      $success = 'Added';
    }


    header('Location: customers.php?page=view&edit_id=' . $edit_id . '&success=' . $success);
    die();
  }
}
?>
<!DOCTYPE html>
<html>
  <head lang="en">

    <title><?= $page_name ?> | <?php echo $site_name; ?> - <?php echo $site_slogan; ?></title>
    <meta name="description" content="<?php echo $site_name . '.' . $site_slogan ?>">

    <?php require_once './includes/head.php'; ?>


  </head>
  <body class="with-side-menu theme-side-litmus-blue">

    <?php require_once './includes/header.php'; ?>

    <?php require_once './includes/side-menu.php'; ?>

    <div class="page-content">
      <div class="container-fluid">

        <header class="section-header">
          <div class="tbl">
            <div class="tbl-row">
              <div class="tbl-cell">
                <a href="customers.php?page=add" class="btn btn-sm btn-primary-outline pull-right"><i class="fa fa-plus" aria-hidden="true"></i><span class="hidden-xs">  Add New</span></a>
                <a href="customers.php?page=view" class="btn btn-sm btn-primary-outline pull-right"><i class="fa fa-list" aria-hidden="true"></i><span class="hidden-xs">  View / Edit</span></a>
                <h3>
                  <?
                  if ($page == 'view') {
                    ?>
                    View      <?= $page_name ?>
                    <?
                  }
                  ?>
                  <?
                  if ($page == 'edit') {
                    ?>
                    Edit      <?= $page_name_single ?>
                    <?
                  }
                  ?>
                  <?
                  if ($page == 'add') {
                    ?>
                    Add      <?= $page_name_single ?>
                    <?
                  }
                  ?>

                </h3>
              </div>
            </div>
          </div>
        </header>

        <?
        if ($errors != '') {
          echo '<div class = "alert alert-block alert-danger fade in">';
          foreach ($errors as $error) {
            echo '<p>' . $error . '.</p>';
          }
          echo '</div>';
        }
        if ($success != '') {
          echo '<div class = "alert alert-block alert-success fade in">';
          //foreach ($successes as $success) {
          echo '<p><b>' . $edit_id . '</b>  ' . $success . '.</p>';
          //}
          echo '</div>';
        }
        ?>
        <?
        if ($page == 'add' || $page == 'edit') {
          ?>
          <form enctype="multipart/form-data" role="form" method="POST" action="<?= $_SERVER['PHP_SELF'] ?>?page=<?= $page ?><? if ($edit_id != '') echo '&edit_id=' . $edit_id; ?>">


            <div class="row">

              <div class="col-sm-4 col-sm-offset-4">

                <div class="box-typical box-typical-padding">

                  <div class="row">
                    <div class="col-sm-12">
                      <div class="row">

                        <div class="col-sm-12">
                          <div class="form-group">
                            <label for="edit_name">Name</label>
                            <div>
                              <input type="text" id="edit_name" name="edit_name" class="form-control validate[required,maxSize[255]]" value="<?= $edit_name ?>"/>
                            </div>
                            <div class="clearfix"></div>
                          </div>
                        </div>

                        <div class="col-sm-12">
                          <div class="form-group">
                            <label for="edit_phone">Mobile</label>
                            <div>
                              <input type="text" id="edit_phone" name="edit_phone" class="form-control validate[required,maxSize[255]]" value="<?= $edit_phone ?>"/>
                            </div>
                            <small class="help-block text-muted" style="margin-top: 5px;">No white spaces or dashes. Add 92 instead of 0.<br/>For Example: 923214567890</small>
                            <div class="clearfix"></div>
                          </div>
                        </div>

                        <div class="col-sm-12">
                          <div class="form-group">
                            <label for="edit_email">Email</label>
                            <div>
                              <input type="text" id="edit_email" name="edit_email" class="form-control validate[required,maxSize[255]]" value="<?= $edit_email ?>"/>
                            </div>
                            <div class="clearfix"></div>
                          </div>
                        </div>
                        <div class="col-sm-12">

                          <div class="form-group">
                            <label for="edit_is_active">Is active</label>
                            <div>

                              <select id="edit_is_active" name="edit_is_active" class="form-control validate[maxSize[255]]">
                                <option value=""></option>
                                <?
                                if ($edit_is_active == '1') {
                                  $selected1 = ' selected'; // male
                                  $selected2 = ' ';
                                } elseif ($edit_is_active == '0') {
                                  $selected1 = ' ';
                                  $selected2 = ' selected'; // female
                                } else {
                                  $selected1 = ' '; // male
                                  $selected2 = ' ';
                                }
                                ?>
                                <option value="1" <?= $selected1 ?>>Yes</option>
                                <option value="0" <?= $selected2 ?>>No</option>
                              </select>
                            </div>
                            <div class="clearfix"></div>
                          </div></div>
                        <div class="clearfix"></div>


                      </div>
                    </div>
                  </div>


                </div>
              </div>
            </div>

            <div class="form-group text-center" >

              <?
              if ($page == 'add') {
                ?>
                <button type="submit" class="btn btn-success" name="edit_submit" id="edit_submit"><i class="fa fa-check"></i>
                  Add
                </button>
                <?
              }
              ?>
              <?
              if ($page == 'edit') {
                ?>
                <button type="submit" class="btn btn-success" name="edit_submit" id="edit_submit"><i class="fa fa-check"></i>
                  Update
                </button>
                <?
              }
              ?>

              <a href="customers.php" class="btn btn-default"><i class="fa fa-times"></i>
                Cancel
              </a>
            </div>


          </form>

          <?
        } elseif ($page == 'view' || $page == 'my') {
          ?>
          <div class="box-typical box-typical-padding">

            <table class="table table-hover table-striped width-full table-striped table-bordered" data-plugin="dataTable">
              <thead>
                <tr>
                  <th style="background-color: #efefef">#</th>
                  <th>Name</th>
                  <th>Mobile</th>
                  <th>Email</th>
                  <th class="hidden-xs">Is active</th>
                  <th><?php echo 'Actions' ?></th>
                </tr>
              </thead>
              <temail>
                <?
                // $db->setTrace(true);
                $db->orderBy("name", "desc");

                $db->where('is_delete', 0);
                $edit_infos = $db->get('customers');
                // print_r($db->trace);
                if ($db->count > 0) {
                  $counter = 1;
                  foreach ($edit_infos as $edit_info) {

                    if ($edit_info['is_active'] == 1) {
                      $edit_info['is_active'] = 'Yes';
                    } else {
                      $edit_info['is_active'] = 'No';
                    }
                    ?>
                    <tr>
                      <td style="background-color: #efefef"><?php echo $counter ?></td>
                      <td><?php echo htmlspecialchars($edit_info['name']) ?></td>
                      <td><?php echo htmlspecialchars($edit_info['phone']) ?></td>
                      <td><?php echo htmlspecialchars($edit_info['email']) ?></td>
                      <td class="hidden-xs"><?php echo htmlspecialchars($edit_info['is_active']) ?></td>

                      <td class="actions" >

                        <?
//                        if ($edit_info['user_id'] == $user_id || $superadmin == 1) {
                        ?>
                        <a href="customers.php?page=edit&edit_id=<?= $edit_info['id'] ?>" class="btn btn-sm btn-primary-outline"><i class="fa fa-edit" aria-hidden="true"></i><span class="hidden-xs"> Edit</span></a>

                        <a href="#" data-href="customers.php?edit_id=<?= $edit_info['id'] ?>&do_delete=1" data-confirm="Confirm" class="btn btn-sm btn-primary-outline btn-delete"><i class="fa fa-remove" aria-hidden="true"></i><span class="hidden-xs"> Delete</span></a>
                            <? // } ?>
                      </td>
                    </tr>
                    <?php
                    $counter++;
                  }
                }
//            else {
//
//              echo '<tr class="text-center"><td colspan="6">No ' . $page_name_single . ' yet.</td></tr>';
//            }
                ?>
              </temail>
            </table>

          </div>
          <?
        }
        ?>

      </div><!--.container-fluid-->
    </div><!--.page-content-->

    <?php require_once './includes/footer.php'; ?>

  </body>
</html>